#!/QOpenSys/usr/bin/sh
#
# run_csvExce.sh <USERID> <File Transfer Mode> <csv file name or bnd file name> <status file name>
#

# =======================
# arg get
# -----------------------
if [ $# -ne 4 ]; then
   echo $1 $2 $3 $4 $5 
   echo "Usage: $0 <USERID> <Export Mode> <csv or bnd fileName> <status file name>"
   exit 1
fi

USER=$1
EXPORT=$2
FILENAME=$3
STATUS_FILE=$4

# =======================================
# /home/USER DIRECTORY Check and Create
# ---------------------------------------

HOMEDIR=/home/$USER
EXCELDIR=$HOMEDIR/excel

if [ ! -d $HOMEDIR ]; then
   mkdir $HOMEDIR
fi

if [ ! -d $EXCELDIR ]; then
   mkdir $EXCELDIR
fi

cd $EXCELDIR

if [ ${EXPORT} = "IMP" ]; then
   # CPYTOIMPFŃf[^ϊꍇAs̖ɏo͂]폜B
   TXT_F=`echo ${FILENAME} | awk '{ sub(/.CSV$/, ".TXT", $0); print $0}'`
   mv ${FILENAME} ${TXT_F}
   cat ${TXT_F} | awk '{sub(/[[:space:]]+$/, "", $0); print $0}' > ${FILENAME}
   rm -f ${TXT_F}
fi


/QOpenSys/pkgs/bin/python /opt/excel/csvExcel.py $FILENAME $STATUS_FILE
RTNCODE=$?

exit $RTNCODE
